﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class BlinkLabel : Label
    {
        public BlinkLabel()
        {
            InitializeComponent();
            timer1.Interval = 500;
            timer1.Start();
        }

        //Wir fügen noch ein wenig Code ein um eigene Eigenschaften zu demonstrieren
        [Description("Legt das Intervall fest.")]
        [Category("Essentiell")]
        [DefaultValue(500)]
        public int Interval
        { 
            get { return timer1.Interval; }
            set { timer1.Interval = value; }
        }

        protected override void OnPaint(PaintEventArgs pe)
        {
            //Hier können eigene Zeichenroutinen eingearbeitet werden - mehr dazu später
            base.OnPaint(pe);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            //Einfach immer wieder umschalten.
            Visible = !Visible;
        }

        //Das alte Enabled wird versteckt - es kann sonst nicht überschrieben werden 
        //(Nutzen dies zum Deaktivieren des Controls)
        //++Wichtig++ wir wissen beim verstecken können wir nicht über z.B. Label.Enabled oder Control.Enabled
        //            diese Eigenschaft verändern - wir müssen explizit den Typ des BlinkLabels ansprechen
        public new bool Enabled 
        { 
            get { return base.Enabled; }
            set { 
                base.Enabled = value;

                if (value)
                    timer1.Start();
                else
                    timer1.Stop();

                Visible = value;
            }
        }
    }
}
